//
//  MCObjectPool.h
//  MCHTTPServer
//
//  Created by Brent Gulanowski on 10-09-13.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


@protocol MCObjectPoolClient<NSObject>

// Vends the object asynchronously to a requester; requester can return NO if the object is no longer needed
- (void)poolObjectReady:(id)object userInfo:(id)userInfo;
- (void)objectCheckedIn:(id)object;

@end



@interface MCObjectPool : NSObject {
	
	NSUInteger poolSize;
	NSUInteger queueSize;
	
	Class objectClass;
	NSInvocation *initInvocation;
	
	NSMutableArray *requestQueue;
	NSMutableSet *busyObjects;
	NSMutableSet *freeObjects;
}

@property (nonatomic) NSUInteger poolSize;
@property (nonatomic) NSUInteger queueSize;

// Private properties
@property (nonatomic, assign) Class objectClass;
@property (nonatomic, retain) NSInvocation *initInvocation;
@property (retain) NSMutableArray *requestQueue;
@property (retain) NSMutableSet *busyObjects;
@property (retain) NSMutableSet *freeObjects;

- (MCObjectPool *)initWithClass:(Class)aClass initInvocation:(NSInvocation *)anInvocation;
- (MCObjectPool *)initWithClass:(Class)aClass initSelector:(SEL)selector arguments:(NSArray *)arguments;

- (void)populatePool;
- (void)emptyPool;

// Adds the sender to the request queue
- (BOOL)requestObject:(id<MCObjectPoolClient>)sender userInfo:(id)info;
// Removes the sender from the request queue
- (void)cancelRequest:(id<MCObjectPoolClient>)sender;
// Marks the object checked out by the sender as available again
- (void)returnObject:(id<MCObjectPoolClient>)sender;


// Private
- (void)tryToFulfillRequests;

@end
